<?php

namespace App\Http\Controllers;

//use Illuminate\Http\Request;
use DB;
use App\Myorder;
use App\User;
use App\Lib\ConvertTHB;
use File;
use DateTime;
use DateTimeZone;
use App\Lib\rmSchar;

class PrintController extends Controller
{
    public function index()
    {
        $html = File::get(base_path('/resources/views/print/template/order.blade.php'));

        //$mpdf = new \Mpdf\Mpdf();

        $mpdf = new \Mpdf\Mpdf([
            'default_font_size' => 9,
            'default_font' => 'sarabun',
            'margin_left' => 20,
            'margin_right' => 15,
            'margin_top' => 48,
            'margin_bottom' => 25,
            'margin_header' => 10,
            'margin_footer' => 10
        ]);

        $mpdf->WriteHTML('ทดสอบคำภาษาไทย');

        $mpdf->SetProtection(array('print'));
        $mpdf->SetTitle("Acme Trading Co. - Invoice");
        $mpdf->SetAuthor("Acme Trading Co.");
        $mpdf->SetWatermarkText("Diag for Life");
        $mpdf->showWatermarkText = true;
        $mpdf->watermark_font = 'DejaVuSansCondensed';
        $mpdf->watermarkTextAlpha = 0.1;
        $mpdf->SetDisplayMode('fullpage');


        $mpdf->WriteHTML($html);


        $mpdf->Output();
    }
    public function export($order_id)
    {
        $myorder = Myorder::where('id', $order_id)->with('orders')->with('address')->first();
        if ($myorder->user_id == auth()->user()->id || auth()->user()->id == '1') {
            $userDetail = User::where('id', $myorder->user_id)->first();
        } else {
            return abort(404);
        }

        $timezone = 'Asia/Bangkok';
        $date = new DateTime('now', new DateTimeZone($timezone));
        //$localtime = $date->format('Y m d H:i:s');
        $YYn = $date->format('Y') + 543;
        $MMn = $date->format('m');
        $DDn = $date->format('d');

        $dateNow = $DDn . '/' . $MMn . '/' . $YYn;

        if (DB::table('myorder_has_numbers')->where('myorder_id', $order_id)->exists()) { } else {
            $lastPO = DB::table('myorder_has_numbers')->orderBy('id', 'desc')->first();

            if (isset($lastPO)) {
                //PO6207-00001

                $lastPOc = $lastPO->code;
                $YY = substr($lastPOc, 2, 2);  // returns "abcde"
                $MM = substr($lastPOc, 4, 2);  // returns "cde"
                $NN = substr($lastPOc, -5, 5);  // returns false

                if ((($YY + 2500) - $YYn) == 0) {
                    if ($MMn > $MM) {
                        $newPOc = 'PO' . $YY . sprintf("%02d", ($MM + 1)) . "-00001";
                    } else {
                        $num = (int) $NN + 1;
                        $num_padded = sprintf("%05d", $num);
                        $newPOc = 'PO' . $YY . $MM . "-" . $num_padded;
                    }
                } else if ((($YY + 2500) - $YYn) < 0) {
                    $newPOc = 'PO' . sprintf("%02d", ($YY + 1)) . "01-00001";
                } else {
                    return abort(404);
                }
            } else {
                $newPOc = 'PO' . substr($YYn, 2, 2) . $MMn . "-00001";
            }
            //insert
            DB::table('myorder_has_numbers')->insert(
                [
                    'myorder_id' => $order_id,
                    'code' => $newPOc,
                    'date' => $dateNow
                ]
            );
        }

        $PO_table = DB::table('myorder_has_numbers')->where('myorder_id', $order_id)->first();
        //return $PO_table->code;

        $hCSS = File::get(base_path('/resources/views/print/template/cssPO.blade.php'));

        $TrueAddress = rmSchar::rm($myorder->address->address);

        if($myorder->address->province == 'กรุงเทพมหานคร'){
            $FullAddress = $TrueAddress . ' แขวง ' . $myorder->address->sub_district
                . '<br>เขต ' . $myorder->address->district . ' ' . $myorder->address->province . '  ' . $myorder->address->zipcode . '';

        }else{
            $FullAddress = $TrueAddress . ' ต.' . $myorder->address->sub_district
                . '<br>อ.' . $myorder->address->district . ' จ.' . $myorder->address->province . '  ' . $myorder->address->zipcode . '';
        }
        
        $hHeaderFooter = '
        <!--mpdf
    <htmlpageheader name="myheader">
    <table width="100%"><tr>
    <td class="mt-1" width="50%" style="">
    <span style="font-weight: bold; font-size: 14pt;">ห้างหุ้นส่วนจำกัด ไดแอก ฟอร์ ไลฟ์</span><br />
    269/1 ม. 12 ต.บ้านเป็ด อ.เมืองขอนแก่น จ.ขอนแก่น 40000<br/>
    โทร.043-258335, แผนกลูกค้าสัมพันธ์ 092-2237453, โทรสาร.043-258336<br/>
    เลขประจำตัวผู้เสียภาษี 0403554002859 </td>
    <td width="50%" style="text-align: right;">
    <img src="http://www.diagforlife.co.th/images/LogoDiag.png" alt="" width="130" height="36"><br><br/>
    <br/><table width="60%" style="font-size: 12pt;"><tr>
    <td width="40%" ></td>
    <td width="20%"><span style="font-weight: bold;">เลขที่<br/>วันที่
    </span></td>
    <td width="40%" style="text-align: left;">' . $PO_table->code . '
    <br/>' . $PO_table->date . '</td>
    </tr></table></td>
    </tr></table>
    </htmlpageheader>

    <htmlpagefooter name="myfooter">
    <table width="100%"  style="font-size: 12pt;"><tr>
    <td class="mt-1" width="40%" style="text-align: center;"><br />
    <span style="font-weight: bold; font-size: 14pt;">สำหรับลูกค้า</span><br />
    ยืนยันสั่งซื้อตามรายการที่เสนอทั้งหมด<br/><br/>
    <p style="text-align: left;">ลงชื่อผู้สั่งซื้อ: <span>..........................................</span></p>
    <p style="text-align: left;">วันที่ทำการสั่งซื้อ: <span>....................................</span></p></td>
    <td width="30%" style="text-align: right;"></td>
    <td width="30%" style="text-align: center;">
    <img src="http://www.diagforlife.co.th/img/sig/sig' . $userDetail->id . '.png" alt="" height="35"><hr>
    ( ' . $userDetail->fullname . ' )<br />
    <span style="font-weight: bold; font-size: 12pt;">ผู้ออกใบสั่งซื้อ</span><br />
    วันที่ ' . $PO_table->date . '
    </td>
    </tr></table>
    </htmlpagefooter>

    <sethtmlpageheader name="myheader" value="on" show-this-page="1" />
    <sethtmlpagefooter name="myfooter" value="on" />
mpdf-->';

        $hAddress = '
        <h1 align="center" >ใบสั่งซื้อ</h1>
        <table width="100%" style="border: 1px solid #000000;font-size: 11pt;"><tr>
    <td width="10%" style="" margin="top">
    <p><span style="font-weight: bold;" >รายชื่อลูกค้า: </span></p>
    <p><span style="font-weight: bold;" >ที่อยู่: </span></p><br>
    <p><span style="font-weight: bold;" >โทร: </span></p>
    </td>
    <td width="60%" style="">
    <p><span style="margin: 35px;">' . rmSchar::rm($myorder->address->name) . '</span></p>
    <p><span style="margin: 35px;">' . $FullAddress . '</span></p>
    <p><span style="margin: 35px;">' . $myorder->address->tel . '</span></p>
    </td>
    <td width="30%">
    <br>
    <p><span style="font-weight: bold;" >เลขที่ใบสั่งซื้อ: </span>
    <span style="margin: 35px;">' . $myorder->customer_po . '</span></p>
    <p><span style="font-weight: bold;" >รหัสลูกค้า: </span>
    <span style="margin: 35px;">DSC' . sprintf("%05d", ($myorder->address->id)) . '</span></p>
    </td>
    </tr></table><br>';
        $hProductT = '<br><br>
        <table class="items" width="100%" style="font-size: 12pt; border-collapse: collapse; " cellpadding="8">
        <thead>
            <tr>
                <td width="8%">ลำดับ</td>
                <td width="40%">รายละเอียด</td>
                <td width="10%">หน่วย</td>
                <td width="10%">จำนวน</td>
                <td width="10%"  align="center">หน่วยละ</td>
                <td width="10%">ส่วนลด</td>
                <td width="12%">จำนวนเงิน</td>
            </tr>
        </thead>
        <tbody>
            <!-- ITEMS HERE -->';

        $hProductL = '';
        $count = 1;
        foreach ($myorder->orders as $row) {
            $hProductL .= '<tr>
                <td align="center">' . $count++ . '</td>
                <td>' . $row->product_name . '</td>
                <td class="unitS">' . $row->unit_name . '</td>
                <td align="right" class="numS">' . $row->qty . '</td>
                <td class="cost" align="right">' . number_format(($row->price_now), 2) . '</td>
                <td></td>
                <td class="cost" align="right">' . number_format(($row->price_now * $row->qty), 2) . "<br>" . '</td>
            </tr>';
        }
        if ($count < 10) {
            for ($x = $count; $x < 11; $x++) {
                $hProductL .= '<tr>
                <td align="center"><br></td>
                <td></td>
                <td></td>
                <td align="right"></td>
                <td class="cost" align="right"></td>
                <td></td>
                <td class="cost"></td>
            </tr>';
            }
        }

        $Tvat = ($myorder->total) * (7 / 107);
        $Tall = $myorder->total;

        if($myorder->remark != '-'){
            $remarkRed = ' - '.rmSchar::rm($myorder->remark);
        }else {
            $remarkRed = '';
        }

        $hTotal = '<!-- END ITEMS HERE -->
            <tr>
                <td class="blanktotal" colspan="4" rowspan="4" style="margin-top"><br>
                <span align="left" style="font-weight: bold; font-size: 12pt;">หมายเหตุ</span>
                <br/><br/><span style="color:red;display:inline-block">'.$remarkRed.'<span/><br/><br/><br/>
                <span style="color:black" align="center">( ' . ConvertTHB::Convert($myorder->total) . ' )</span>
                </td>
                <td class="totals" colspan="2"><p>หัก ส่วนลด<p></td>
                <td class="totals cost"></td>
            </tr>
            <tr>
                <td class="totals" colspan="2">รวมเป็นเงิน</td>
                <td class="totals cost" align="right">' . number_format(($Tall - $Tvat), 2)  . '</td>
            </tr>
            <tr>
                <td class="totals" colspan="2">ภาษีมูลค่าเพิ่ม 7%</td>
                <td class="totals cost" align="right">' . number_format(($Tvat), 2)  . '</td>
            </tr>
            <tr>
                <td class="totals" colspan="2"><b>รวมทั้งสิ้น</b></td>
                <td class="totals cost" align="right"><b>' . number_format(($Tall), 2)  . '</b></td>
            </tr>
        </tbody>
    </table>
    </body>

    </html>';

        $mpdf = new \Mpdf\Mpdf([
            'default_font_size' => 9,
            'default_font' => 'sarabun',
            'margin_left' => 20,
            'margin_right' => 15,
            'margin_top' => 35,
            'margin_bottom' => 25,
            'margin_header' => 10,
            'margin_footer' => 15
        ]);

        $mpdf->SetProtection(array('print'));
        $mpdf->SetTitle("DiagforLife Part., Ltd. - $PO_table->code");
        $mpdf->SetAuthor("DiagforLife Part., Ltd. ");
        //$mpdf->SetWatermarkText("Diag for Life");
        //$mpdf->showWatermarkText = true;
        //$mpdf->watermark_font = 'DejaVuSansCondensed';
        //$mpdf->watermarkTextAlpha = 0.1;
        $mpdf->SetDisplayMode('fullpage');

        $mpdf->WriteHTML($hCSS . $hHeaderFooter . $hAddress . $hProductT . $hProductL . $hTotal);
        //$mpdf->WriteHTML($hCSS);

        $mpdf->Output($PO_table->code . '.pdf', 'I');
        //return $userDetail->id;
        //return $myorder;
    }
    public function test()
    {
        return view('print.template.test');
    }
}
