<?php

namespace App\Http\Controllers;

use App\Price;
use App\Product;
use App\Productname;
use Illuminate\Http\Request;
use Freshbitsweb\Laratables\Laratables;
use App\Lib\rmSchar;

class PriceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('backend.price.index');
    }
    public function indexP($product_id)
    {
        //$product = Product::orderBy('id','desc')->paginate(20);
        $price = Price::with('product')->where('product_id', $product_id)->where('address_id', 1)->orderBy('unit')->paginate(20);
        $product = Product::where('id', $product_id)->first();

        return view('backend.price.indexP', [
            'price' => $price,
            'product' => $product
        ]);

        // return $price;

    }

    public function getPriceAjax()
    {

        return Laratables::recordsOf(Price::class, function ($query) {
            return $query->where('address_id', '1');
        });
    }

    public function getPrice(Request $request)
    {
        //$unit_id = $request->unit_id;
        $price = Price::where('id', $request->unit_id)->first();

        $productN = ProductName::where('product_id', $price->product_id)->where('address_id', $price->address_id)->first();

        if ($productN == '') {
            $productName = '';
        } else {
            $productName = $productN->name;
        }

        $arr = array();
        $arr[0] = $price->price;
        $arr[1] = $productName;
        //response()->json(["productQuanties" => $productQuanties, "productPaperStock" => $productPaperStock])
        return $arr;
    }

    public function setName(Request $request)
    {
        $request->validate([
            'product_name' => 'required'
        ], [
            'product_name.required' => 'กรุณากรอกชื่อสินค้าเพื่อเปลี่ยนชื่อสินค้า'
        ]);
        if (Productname::where('address_id', $request->address_id)->where('product_id', $request->product_id)->exists()) {

            Productname::where('product_id', $request->product_id)
                ->where('address_id', $request->address_id)
                ->update(['name' => $request->product_name]);
        } else {
            $Productname = new Productname();
            $Productname->product_id = $request->product_id;
            $Productname->address_id = $request->address_id;
            $Productname->name = rmSchar::rm($request->product_name);

            $Productname->save();
        }

        //return $request;
        return redirect()->back()->with('feedback', 'แก้ไขชื่อสินค้าเรียบร้อย');
    }

    public static function laratablesRoleRelationQuery()
    {
        return function ($query) {
            $query->with('product');
        };
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($product_id)
    {
        // //$product = Product::all();
        // return view('backend.price.create',[
        //     'product_id' => $product_id
        // ]);
    }
    public function createP($product_id)
    {
        $product = Product::where('id', $product_id)->first();
        return view('backend.price.create', [
            'product' => $product
        ]);

        //return $product;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'unit' => 'required',
            'price' => 'required|numeric'
        ], [
            'unit.required' => 'กรุณากรอกหน่วย',
            'price.required' => 'กรุณากรอกราคา',
            'price.numeric' => 'กรุณากรอกราคาเป็นตัวเลข'
        ]);
        //return $request;
        $Price = new Price();
        $Price->product_id = $request->product_id;
        $Price->unit = rmSchar::rm($request->unit);
        $Price->price = $request->price;
        if (isset($request->address_id)) {
            $Price->address_id = $request->address_id;
        } else {
            $Price->address_id = '1';
        }

        $Price->save();

        return back()->with('feedback', 'บันทึกข้อมูลเรียบร้อย');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Price  $price
     * @return \Illuminate\Http\Response
     */
    public function show(Price $price)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Price  $price
     * @return \Illuminate\Http\Response
     */
    public function edit(Price $price)
    {
        $product = Product::where('id', $price->product_id)->first();
        return view('backend.price.edit', [
            'price' => $price,
            'product' => $product
        ]);

        // return $price;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Price  $price
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Price $price)
    {
        $request->validate([
            'unit' => 'required',
            'price' => 'required|numeric'
        ], [
            'unit.required' => 'กรุณากรอกหน่วย',
            'price.required' => 'กรุณากรอกราคา',
            'price.numeric' => 'กรุณากรอกราคาเป็นตัวเลข'
        ]);
        $price->unit = rmSchar::rm($request->unit);
        $price->price = $request->price;

        $price->save();

        if ($price->address_id == 1) {
            return redirect()->route('price.indexP', ['id' => $price->product_id])->with('feedback', 'แก้ไขข้อมูลเรียบร้อย');
        } else {
            return redirect()->route('cart.pricesale', ['product_id' => $price->product_id, 'address_id' => $price->address_id])->with('feedback', 'แก้ไขข้อมูลเรียบร้อย');
        }

        // return $price;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Price  $price
     * @return \Illuminate\Http\Response
     */
    public function destroy(Price $price)
    {
        $price->delete();
        return back()->with('feedback', 'ลบข้อมูลเรียบร้อย');
    }
}
