<?php

namespace App\Http\Controllers;

use App\Order;
use App\Cart;
use App\Address;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $listCart = auth()->user()->products()->latest()->get();
        $sumPrice = auth()->user()->products()->sum('products.price');
        $sumQty = Cart::where('user_id', auth()->user()->id)->sum('qty');

        return view('cart', [
            'listCart' => $listCart,
            'sumPrice' => $sumPrice,
            'sumQty' => $sumQty
        ]);
    }

    public function index2()
    {
        $listOrder = Order::with('address')->paginate(20);;;

        return view('order.index', [
            'listOrder' => $listOrder
        ]);

        //return $listOrder;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $listCart = auth()->user()->products()->latest()->whereIn('id', $request->checkbox)->get();
        $sumPrice = auth()->user()->products()->whereIn('id', $request->checkbox)->sum('products.price');
        $sumQty = Cart::where('user_id', auth()->user()->id)->whereIn('product_id', $request->checkbox)->sum('qty');
        $address = Address::where('id', $request->address_id)->first();
        $addressFull = $address->address . '<br>'
            . 'ตำบล/แขวง : ' . $address->sub_district . ' อำเภอ/เขต : ' . $address->district . '<br>'
            . 'จังหวัด : ' . $address->province . ' รหัสไปรษณีย์ : ' . $address->zipcode;
        return view('order.checkout', [
            'listCart' => $listCart,
            'sumPrice' => $sumPrice,
            'sumQty' => $sumQty,
            'address' => $address,
            'addressFull' => $addressFull,
            'remark' => $request->remark
        ]);

        //return $request;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Order  $order
     * @return \Illuminate\Http\Response
     */
    public function show(Order $order)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Order  $order
     * @return \Illuminate\Http\Response
     */
    public function edit(Order $order)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Order  $order
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Order $order)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Order  $order
     * @return \Illuminate\Http\Response
     */
    public function destroy(Order $order)
    {
        //
    }

    public function confirm(Request $request)
    {

        //$listCart = auth()->user()->products()->latest()->get();
        $productAll = '';
        foreach ($request->product_id as $p_id) {

            $pData = Cart::with('product')->where('product_id', $p_id)->where('user_id', auth()->user()->id)->first();

            $pName = $pData->product->name;
            $pQty = $pData->qty;
            $pPrice = $pData->product->price;
            $pTotal = $pQty * $pPrice;

            $DetailR = $pName . ':' . $pQty . ':' . $pPrice . ':' . $pTotal;

            if ($productAll == '') {
                $productAll = $p_id;
                $Detail = $DetailR;
            } else {
                $productAll .= '|' . $p_id;
                $pName .= ':' . $pData->product->name;
                $Detail .= '|' . $DetailR;
            }
        }
        //$Detail = $DetailR;

        $order = new Order();
        $order->invoice_id = '1';
        $order->user_id = auth()->user()->id;
        $order->address_id = $request->address_id;
        $order->product = $productAll;
        $order->total = $request->total;
        $order->detail = $Detail;
        $order->remark = $request->remark;
        $order->save();

        foreach ($request->product_id as $p) {
            //delete cart
            auth()->user()->products()->detach($p);
        }

        //return $Detail;
        //return $request->product_id;
        return redirect()->route('welcome')->with('feedback', 'สั่งซื้อสินค้าเรียบร้อย');
    }

    public function checkout()
    {
        $listCart = auth()->user()->products()->latest()->get();
        $sumPrice = auth()->user()->products()->sum('products.price');
        $sumQty = Cart::where('user_id', auth()->user()->id)->sum('qty');

        return view('order.checkout', [
            'listCart' => $listCart,
            'sumPrice' => $sumPrice,
            'sumQty' => $sumQty
        ]);

        //return $orderA;

    }
}
