<?php

namespace App\Http\Controllers;

use App\Order;
use App\Myorder;
use App\Productname;
use App\Price;
use App\Address;
use App\Cart;
use Illuminate\Http\Request;
use App\Lib\rmSchar;

class MyorderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $listOrder = Myorder::where('user_id', auth()->user()->id)->with('orders')->with('myordercode')->orderby('id','desc')->paginate(20);
        return view('myorder.index', [
            'listOrder' => $listOrder
        ]);
        //return $listOrder;
    }

    public function pending()
    {
        $listOrder = Myorder::where('status', 'wait')->with('orders')->with('user')->with('myordercode')->paginate(20);
        return view('myorder.pending', [
            'listOrder' => $listOrder
        ]);
        // return $listOrder;
    }

    public function confirmed()
    {
        $listOrder = Myorder::where('status', 'confirm')->with('orders')->with('user')->with('myordercode')->orderby('id','desc')->paginate(20);
        return view('myorder.confirmed', [
            'listOrder' => $listOrder
        ]);
        // return $listOrder;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    public function error()
    {
        //return 'Error';
        return redirect()->back()->with('feedback_error', 'ยังไม่สามารยกเลิกรายการโดย Admin');
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //Validate
        $request->validate([
            'address_id' => 'required',
            // 'remark' => 'required',
        ], [
            'address_id.required' => 'กรุณาเลือกที่อยู่',
            // 'remark.required' => 'กรุณากรอกหมายเหตุ ถ้าไม่มีใส่เครื่องหมาย (-)',
        ]);

        for ($x = 0; $x < count($request->checkbox); $x++) {
            $Num = explode(":", $request->checkbox[$x]);
            if (!isset($request->unit[$Num[1]])) {
                $request->validate([
                    'unit[]' => 'required',
                ], [
                    'unit[].required' => 'กรุณาเลือกหน่วย',
                ]);
            }
        }

        $address = Address::where('id', $request->address_id)->first();
        $totalall = 0;
        //Set Value
        for ($x = 0; $x < count($request->checkbox); $x++) {

            if ($x == 0) {
                //Store
                $Myorder = new Myorder();
                $Myorder->user_id = auth()->user()->id;
                $Myorder->address_id = $request->address_id;
                $Myorder->address_name = $address->name;
                $Myorder->total = '0';
                if (isset($request->remark)) {
                    $Myorder->remark = rmSchar::rm($request->remark);
                } else {
                    $Myorder->remark = $request->remark;
                }
                if (isset($request->customer_po)) {
                    $Myorder->customer_po = $request->customer_po;
                }
                $Myorder->save();

                $Order_last = Myorder::where('user_id', auth()->user()->id)->orderBy('id', 'desc')->first();
            }

            $Num2 = explode(":", $request->checkbox[$x]);
            $Price = Price::where('id', $request->unit[$Num2[1]])->with('product')->first();
            $Product_name = Productname::where('product_id', $Num2[0])->where('address_id', $request->address_id)->first();
            if (isset($Product_name)) {
                $name_product = $Product_name->name;
            } else {
                $name_product = $Price->product->name;
            }
            //Store
            $Order = new Order();
            $Order->myorder_id = $Order_last->id;
            $Order->product_id = $Num2[0];
            $Order->product_name = $name_product;
            $Order->unit_id = $Price->id;
            $Order->unit_name = $Price->unit;
            $Order->price_now = $Price->price;
            $Order->qty = $request->qty[$Num2[1]];
            $Order->invoice_id = '0';
            $Order->total = $Order->price_now * $Order->qty;

            $Order->save();

            $totalall += $Order->total;

            //delete cart
            auth()->user()->products()->detach($Num2[0]);
        }
        Myorder::where('id', $Order_last->id)->update(['total' => $totalall]);
        //return $Cart;
        return redirect()->route('welcome')->with('feedback', 'ออเดอร์สินค้าสำเร็จ');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Myorder  $myorder
     * @return \Illuminate\Http\Response
     */
    public function show(Myorder $myorder)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Myorder  $myorder
     * @return \Illuminate\Http\Response
     */
    public function edit(Myorder $myorder)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Myorder  $myorder
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Myorder $myorder)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Myorder  $myorder
     * @return \Illuminate\Http\Response
     */
    public function destroy(Myorder $myorder)
    {
        $myorder->delete();

        return redirect()->back()->with('feedback', 'ยกเลิกรายการเรียบร้อย');
    }
    public function reuse($myorder_id)
    {
        $order_product = Order::where('myorder_id', $myorder_id)->get();

        for ($x = 0; $x < count($order_product); $x++) {

            if (Cart::where('user_id', auth()->user()->id)->where('product_id', $order_product[$x]->product_id)->exists()) { } else {
                $cart = new Cart();

                $cart->user_id = auth()->user()->id;
                $cart->product_id = $order_product[$x]->product_id;
                $cart->qty = '1';

                $cart->save();
            }
        }
        //return $order_product;
        $myorder = Myorder::find($myorder_id);
        $myorder->delete();

        return redirect()->route('cart.index')->with('feedback2', 'กรุณาตรวจสอบรายการสินค้า')->with('icon', 'warning');
        //return $myorder_id;
    }
}
