<?php

namespace App\Http\Controllers;

use App\Invoice;
use Illuminate\Http\Request;
use DB;
use App\Myorder;
use App\Order;

class InvoiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    public function confirm($myorder_id)
    {
        if (DB::table('myorder_has_numbers')->where('myorder_id', $myorder_id)->exists()) {

            //Update Confirm
            Myorder::where('id', $myorder_id)->update(['status' => 'confirm']);

            //Create Invoice
            $myorder = Myorder::where('id', $myorder_id)->first();

            $invoice = new Invoice();
            $invoice->total = $myorder->total;
            $invoice->user_id = $myorder->user_id;
            $invoice->myorder_id = $myorder->id;
            $invoice->address_id = $myorder->address_id;

            $invoice->save();

            Order::where('myorder_id', $myorder_id)->update(['invoice_id' => '1']);

            return back()->with('feedback', 'ยืนยันรายการสำเร็จ');

        } else {
            return back()->with('feedback_W', 'กรุณาสร้างใบสั่งซื้อก่อน')->with('feedback_Ws', '(PDF)');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return $request;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function show(Invoice $invoice)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function edit(Invoice $invoice)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Invoice $invoice)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function destroy(Invoice $invoice)
    {
        //
    }
}
