<?php

namespace App\Http\Controllers;

use App\Category;
use Illuminate\Http\Request;
use Freshbitsweb\Laratables\Laratables;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //$category = Category::all();
        //$category = Category::findOrFail(1);//404
        //$category = Category::find(1);
        //$category = Category::where('id','>',1)->get();
        //$category = Category::select('id','name')-> where('id','>',1)->get();


        $category = Category::paginate(20);
        $countRow = Category::count();

        //return $category;
        return view('backend.category.index', [
            'category' => $category,
            'countRow' => $countRow
        ]);
    }

    public function category2()
    {
        return view('backend.category.category2');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //$category = Category::all();
        return view('backend.category.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //Validate
        $request->validate([
            'name' => 'required',
        ], [
            'name.required' => 'กรุณาใส่ชื่อประเภทสินค้า',
        ]);

        $product = new Category();
        $product->name = $request->name;

        $product->save();

        return redirect()->route('category.index')->with('feedback', 'บันทึกข้อมูลเรียบร้อย');

        //return $request->checkbox;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function show(Category $category)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function edit(Category $category)
    {
        return view('backend.category.edit', [
            'category' => $category
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Category $category)
    {
        //Validate
        $request->validate([
            'name' => 'required',
        ], [
            'name.required' => 'กรุณาใส่ชื่อประเภทสินค้า',
        ]);

        $category->name = $request->name;

        $category->save();

        return redirect()->route('category.index')->with('feedback', 'แก้ไขข้อมูลเรียบร้อย');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function destroy(Category $category)
    {
        $category->delete();
        return redirect()->route('category.index')->with('feedback', 'ลบข้อมูลเรียบร้อย');
    }
    public function getCategoryAjax()
    {

        return Laratables::recordsOf(Category::class);
    }
}
