<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Cart;
use App\Order;
use App\Address;
use App\Price;
use App\Product;
use App\Productname;

class CartController extends Controller
{
    public function index()
    {
        $address_id = 1;
        //$listCart =  Cart::where('user_id', auth()->user()->id)->with('product')->get();
        $listCart = auth()->user()->products()->latest()->with(['prices' => function ($query) use ($address_id) {
            $query->where('address_id', $address_id);
        }])->get();
        //$sumPrice = auth()->user()->products()->sum('products.price');
        $sumQty = Cart::where('user_id', auth()->user()->id)->sum('qty');
        //->with('price')

        // return $listCart;
        return view('cart', [
            'listCart' => $listCart,
            //'sumPrice' => $sumPrice,
            // 'address_id' => $address_id,
            'sumQty' => $sumQty
        ]);
    }


    public function cart_sale($address_id)
    {
        // return $listCart;
        if (Address::where('id', $address_id)->where('user_id', auth()->user()->id)->exists()) {

            //$listCart =  Cart::where('user_id', auth()->user()->id)->with('product')->get();
            $listCart = auth()->user()->products()->latest()->with(['prices' => function ($query) use ($address_id) {
                $query->where('address_id', $address_id);
            }])->get();
            //$sumPrice = auth()->user()->products()->sum('products.price');
            $sumQty = Cart::where('user_id', auth()->user()->id)->sum('qty');
            //->with('price')

            return view('cart', [
                'listCart' => $listCart,
                'address_id' => $address_id,
                'sumQty' => $sumQty
            ]);
        } else {
            abort(404);
        }
    }

    public function price_sale($product_id, $address_id)
    {
        if (Address::where('id', $address_id)->where('user_id', auth()->user()->id)->exists()) {

        $priceMid = Price::where('product_id', $product_id)->where('address_id', '1')->orderBy('unit')->get();
        $price = Price::with('product')->where('product_id', $product_id)->where('address_id', $address_id)->orderBy('unit')->paginate(20);
        $product = Product::where('id', $product_id)->first();
        $address = Address::where('id', $address_id)->first();
        $productN = ProductName::where('product_id', $product_id)->where('address_id', $address_id)->first();

        if($productN==''){
            $productN = '';
        }else {
            $productN = $productN->name;
        }
            return view('sale.price_edit', [
                'priceMid' => $priceMid,
                'price' => $price,
                'product' => $product,
                'productN' => $productN,
                'address' => $address
            ]);

            // return $productN;
        } else {
            abort(404);
        }
    }


    public function store($product_id, $newqty)
    {
        $qty = auth()->user()->products()->where('product_id', $product_id)->first();

        // if ($fn == 'new') {
        //     if (isset($qty)) {
        //         auth()->user()->products()->syncWithoutDetaching([$product_id => ['qty' => $qty->pivot->qty + 1]]);
        //     } else {
        //         auth()->user()->products()->syncWithoutDetaching([$product_id => ['qty' => 1]]);
        //     }
        // } else if ($newqty == '0') { }
        // else {
        if (isset($newqty)) {
            auth()->user()->products()->syncWithoutDetaching([$product_id => ['qty' => $newqty]]);
        } else {
            auth()->user()->products()->syncWithoutDetaching([$product_id => ['qty' => 1]]);
        }
        //}


        return back();
        //return back()->with('feedback', 'เพิ่มสินค้าลงในตะกร้าเรียบร้อย');

        //return $product_id;
    }
    // public function add2cart(Request $request)
    // {
    //     echo $request;
    // }

    public function delete($product_id)
    {
        auth()->user()->products()->detach($product_id);

        return back()->with('feedback', 'ลบสินค้าลงในตะกร้าเรียบร้อย');
    }

    public function confirm()
    {

        $listCart = auth()->user()->products()->latest()->get();

        foreach ($listCart as $p) {
            $order = new Order();
            $order->user_id = auth()->user()->id;
            $order->product_id = $p->id;
            $order->qty = $p->pivot->qty;
            $order->price = $p->price;
            $order->total = ($p->pivot->qty * $p->price);
            $order->save();

            //delete cart
            auth()->user()->products()->detach($p->id);
        }


        return redirect()->route('welcome')->with('feeback', 'สั่งซื้อสินค้าเรียบร้อยแล้ว');
    }
    public function fetch(Request $request)
    {
        //$address_id =  $request->value;

        $address = Address::where('id', $request->value)->first();

        $addressFull = $address->address . '<br>'
            . 'ตำบล/แขวง : ' . $address->sub_district . ' อำเภอ/เขต : ' . $address->district . '<br>'
            . 'จังหวัด : ' . $address->province . ' รหัสไปรษณีย์ : ' . $address->zipcode;

        $output = '<table class="table table-hover shopping-cart-wrap">
        <thead class="text-muted">
            <tr>
                <th scope="col">ชื่อ</th>
                <th scope="col">ที่อยู่</th>
                <th scope="col">เบอร์โทรศัพท์</th>
            </tr>
        </thead>
            <tbody>
                <tr>
                    <td>
                        <figure class="media">
                            <figcaption class="media-body">
                                <h6 class="title text-truncate">' . $address->name . '</h6>
                            </figcaption>
                        </figure>
                    </td>
                    <td>
                        <figure class="media">
                            <figcaption class="media-body">
                                <h6 class="title text-truncate">' . $addressFull . '</h6>
                            </figcaption>
                        </figure>
                    </td>
                    <td>
                        <figure class="media">
                            <figcaption class="media-body">
                                <h6 class="title text-truncate">' . $address->tel . '</h6>
                            </figcaption>
                        </figure>
                    </td>
                    <td>
                        <figure class="media">
                            <figcaption class="media-body">
                                <a href="../address/' . $address->id . '/edit">แก้ไข</a>
                            </figcaption>
                        </figure>
                    </td>
                </tr>
            </tbody>
        </table>';
        echo $output;
    }
}
