<?php

namespace App\Http\Controllers;

use DB;
use App\Address;
use App\User;
use Illuminate\Http\Request;
use Freshbitsweb\Laratables\Laratables;
use App\Lib\rmSchar;

class AddressController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('address.index');
        // $user = User::find(1)->Addresses()->get();
        // return $user;
        ////return back();
    }

    public function getAddressAjax()
    {
        return Laratables::recordsOf(Address::class, function ($query) {
            if (auth()->user()->id != '1') {
                return $query->where('user_id', auth()->user()->id);
            } else {
                return $query->where('user_id', '<>', '');
            }
        });
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //$user_id = auth()->user();
        $province = DB::table('_provinces')->orderBy('name_th')->get();

        return view('address.create', [
            'province' => $province
        ]);
    }

    public function fetch(Request $request)
    {
        $select = $request->get('select');
        $value = $request->get('value');
        $dependent = $request->get('dependent');

        if ($select == 'provinces') {

            $Ndata = DB::table('_provinces')->where('name_th', $value)->get();
            foreach ($Ndata as $N) {
                $data = DB::table('_districts')->where('province_id', $N->id)->orderBy('name_th')->get();
            }

            $output = '<option value="">เลือกอำเภอ/เขต...</option>';

            foreach ($data as $row) {
                $output .= '<option value="' . $row->name_th . '">' . $row->name_th . '</option>';
            }
        } else if ($select == 'districts') {

            $NdataSD = DB::table('_districts')->where('name_th', $value)->get();
            foreach ($NdataSD as $N) {
                $dataSD = DB::table('_sub_districts')->where('district_id', $N->id)->orderBy('name_th')->get();
            }

            $output = '<option value="">เลือกตำบล/แขวง...</option>';

            foreach ($dataSD as $row) {
                $output .= '<option value="' . $row->name_th . '">' . $row->name_th . '</option>';
            }
        } else if ($select == 'sub_districts') {

            $dataZ = DB::table('_sub_districts')->where('name_th', $value)->get();

            foreach ($dataZ as $row) {
                $output = $row->zip_code;
            }
            //$output = "555";
        }

        echo $output;
        //echo '<option value="555">'.$value.'</option>';
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'address' => 'required',
            'province' => 'required',
            'district' => 'required',
            'sub_district' => 'required',
            'zipcode' => 'required|numeric',
            'tel' => 'required',
        ], [
            'name.required' => 'กรุณากรอกชื่อ',
            'address.required' => 'กรุณากรอที่อยู่',
            'province.required' => 'กรุณาเลือกจังหวัด',
            'district.required' => 'กรุณาเลือกอำเภอ/เขต',
            'sub_district.required' => 'กรุณาเลือกตำบล/แขวง',
            'zipcode.required' => 'กรุณากรอกรหัสไปรษณีย์',
            'zipcode.numeric' => 'กรุณากรอกรหัสไปรษณีย์เป็นตัวเลข',
            'tel.required' => 'กรุณากรอกเบอร์โทรศัพท์'
        ]);
        $address = new Address();
        $address->name = rmSchar::rm($request->name);
        $address->user_id = auth()->user()->id;
        $address->type = 'test';
        $address->address = rmSchar::rm($request->address);
        $address->province = $request->province;
        $address->district = $request->district;
        $address->sub_district = $request->sub_district;
        $address->zipcode = $request->zipcode;
        $address->tel = $request->tel;

        $address->save();

        return redirect()->route('address.index')->with('feedback', 'บันทึกข้อมูลเรียบร้อย');
        //return $request;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Address  $address
     * @return \Illuminate\Http\Response
     */
    public function show(Address $address)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Address  $address
     * @return \Illuminate\Http\Response
     */
    public function edit(Address $address)
    {
        if ($address->user_id == auth()->user()->id || auth()->user()->id == '1') {
            $Ndata = DB::table('_provinces')->where('name_th', $address->province)->get();
            foreach ($Ndata as $N) {
                $district = DB::table('_districts')->where('province_id', $N->id)->get();
            }
            $NdataSD = DB::table('_districts')->where('name_th', $address->district)->get();
            foreach ($NdataSD as $N) {
                $sub_district = DB::table('_sub_districts')->where('district_id', $N->id)->get();
            }

            return view('address.edit', [
                'address' => $address,
                'district' => $district,
                'sub_district' => $sub_district,
            ]);
        } else {
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Address  $address
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Address $address)
    {
        $address->name = rmSchar::rm($request->name);
        //$address->user_id = auth()->user()->id;
        //$address->type = 'test';
        $address->address = rmSchar::rm($request->address);
        $address->province = $request->province;
        $address->district = $request->district;
        $address->sub_district = $request->sub_district;
        $address->zipcode = $request->zipcode;
        $address->tel = $request->tel;

        $address->save();

        return redirect()->route('address.index')->with('feedback', 'บันทึกข้อมูลเรียบร้อย');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Address  $address
     * @return \Illuminate\Http\Response
     */
    public function destroy(Address $address)
    {
        $address->delete();
        return redirect()->route('address.index')->with('feedback', 'ลบข้อมูลเรียบร้อย');

        //return $address;
    }
}
