<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Address extends Model
{
    public function user()
    {
        //cat_id fk of product and c_id pk of category
        //return $this->belongsTo(Category::class,'cat_id','c_id');
        return $this->belongsTo(User::class);
    }

    public static function laratablesModifyCollection($addresses)
    {
        return $addresses->map(function ($Myaddress) {

            $Myaddress->address = $Myaddress->address . '<br>ตำบล/แขวง ' . $Myaddress->sub_district
                . ' อำเภอ/เขต ' . $Myaddress->district . '<br>จังหวัด ' . $Myaddress->province
                . ' รหัสไปรษณีย์ ' . $Myaddress->zipcode;

            return $Myaddress;
        });
    }

    public static function laratablesCustomAction($address)
    {
        return view('address.includes.action', compact('address'))->render();
    }

    public function laratablesRowData()
    {
        return [
            'id' => $this->id
        ];
    }
}
